%------------------------------------------------------------------------------
% File     : SYO068^4.020 : TPTP v7.4.0. Released v4.0.0.
% Domain   : Logic Calculi (Intuitionistic logic)
% Problem  : ILTP Problem SYJ204+1.020
% Version  : [Goe33] axioms.
% English  :

% Refs     : [Goe33] Goedel (1933), An Interpretation of the Intuitionistic
%          : [Gol06] Goldblatt (2006), Mathematical Modal Logic: A View of
%          : [ROK06] Raths et al. (2006), The ILTP Problem Library for Intu
%          : [Ben09] Benzmueller (2009), Email to Geoff Sutcliffe
%          : [BP10]  Benzmueller & Paulson (2009), Exploring Properties of
% Source   : [Ben09]
% Names    : SYJ204+1.020 [ROK06]

% Status   : Theorem
% Rating   : 0.29 v7.4.0, 0.22 v7.2.0, 0.12 v7.1.0, 0.38 v7.0.0, 0.29 v6.4.0, 0.33 v6.3.0, 0.40 v6.2.0, 0.57 v6.1.0, 0.43 v5.5.0, 0.33 v5.4.0, 0.60 v5.1.0, 0.80 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.0
% Syntax   : Number of formulae    :   84 (   0 unit;  41 type;  19 defn)
%            Number of atoms       :  297 (  19 equality;  48 variable)
%            Maximal formula depth :    8 (   5 average)
%            Number of connectives :  219 (   3   ~;   1   |;   2   &; 211   @)
%                                         (   0 <=>;   2  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :  116 ( 116   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   44 (  41   :;   0   =)
%            Number of variables   :   40 (   1 sgn;   7   !;   2   ?;  31   ^)
%                                         (  40   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : This is an ILTP problem embedded in TH0
%------------------------------------------------------------------------------
include('Axioms/LCL010^0.ax').
%------------------------------------------------------------------------------
thf(p0_type,type,(
    p0: $i > $o )).

thf(p1_type,type,(
    p1: $i > $o )).

thf(p10_type,type,(
    p10: $i > $o )).

thf(p11_type,type,(
    p11: $i > $o )).

thf(p12_type,type,(
    p12: $i > $o )).

thf(p13_type,type,(
    p13: $i > $o )).

thf(p14_type,type,(
    p14: $i > $o )).

thf(p15_type,type,(
    p15: $i > $o )).

thf(p16_type,type,(
    p16: $i > $o )).

thf(p17_type,type,(
    p17: $i > $o )).

thf(p18_type,type,(
    p18: $i > $o )).

thf(p19_type,type,(
    p19: $i > $o )).

thf(p2_type,type,(
    p2: $i > $o )).

thf(p20_type,type,(
    p20: $i > $o )).

thf(p3_type,type,(
    p3: $i > $o )).

thf(p4_type,type,(
    p4: $i > $o )).

thf(p5_type,type,(
    p5: $i > $o )).

thf(p6_type,type,(
    p6: $i > $o )).

thf(p7_type,type,(
    p7: $i > $o )).

thf(p8_type,type,(
    p8: $i > $o )).

thf(p9_type,type,(
    p9: $i > $o )).

thf(axiom1,axiom,
    ( ivalid @ ( iatom @ p20 ) )).

thf(axiom2,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p1 ) @ ( iimplies @ ( iatom @ p1 ) @ ( iatom @ p0 ) ) ) )).

thf(axiom3,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p2 ) @ ( iimplies @ ( iatom @ p2 ) @ ( iatom @ p1 ) ) ) )).

thf(axiom4,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p3 ) @ ( iimplies @ ( iatom @ p3 ) @ ( iatom @ p2 ) ) ) )).

thf(axiom5,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p4 ) @ ( iimplies @ ( iatom @ p4 ) @ ( iatom @ p3 ) ) ) )).

thf(axiom6,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p5 ) @ ( iimplies @ ( iatom @ p5 ) @ ( iatom @ p4 ) ) ) )).

thf(axiom7,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p6 ) @ ( iimplies @ ( iatom @ p6 ) @ ( iatom @ p5 ) ) ) )).

thf(axiom8,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p7 ) @ ( iimplies @ ( iatom @ p7 ) @ ( iatom @ p6 ) ) ) )).

thf(axiom9,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p8 ) @ ( iimplies @ ( iatom @ p8 ) @ ( iatom @ p7 ) ) ) )).

thf(axiom10,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p9 ) @ ( iimplies @ ( iatom @ p9 ) @ ( iatom @ p8 ) ) ) )).

thf(axiom11,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p10 ) @ ( iimplies @ ( iatom @ p10 ) @ ( iatom @ p9 ) ) ) )).

thf(axiom12,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p11 ) @ ( iimplies @ ( iatom @ p11 ) @ ( iatom @ p10 ) ) ) )).

thf(axiom13,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p12 ) @ ( iimplies @ ( iatom @ p12 ) @ ( iatom @ p11 ) ) ) )).

thf(axiom14,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p13 ) @ ( iimplies @ ( iatom @ p13 ) @ ( iatom @ p12 ) ) ) )).

thf(axiom15,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p14 ) @ ( iimplies @ ( iatom @ p14 ) @ ( iatom @ p13 ) ) ) )).

thf(axiom16,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p15 ) @ ( iimplies @ ( iatom @ p15 ) @ ( iatom @ p14 ) ) ) )).

thf(axiom17,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p16 ) @ ( iimplies @ ( iatom @ p16 ) @ ( iatom @ p15 ) ) ) )).

thf(axiom18,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p17 ) @ ( iimplies @ ( iatom @ p17 ) @ ( iatom @ p16 ) ) ) )).

thf(axiom19,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p18 ) @ ( iimplies @ ( iatom @ p18 ) @ ( iatom @ p17 ) ) ) )).

thf(axiom20,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p19 ) @ ( iimplies @ ( iatom @ p19 ) @ ( iatom @ p18 ) ) ) )).

thf(axiom21,axiom,
    ( ivalid @ ( iimplies @ ( iatom @ p20 ) @ ( iimplies @ ( iatom @ p20 ) @ ( iatom @ p19 ) ) ) )).

thf(con,conjecture,
    ( ivalid @ ( iatom @ p0 ) )).

%------------------------------------------------------------------------------
